/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BoomboxEntityRinger
implements IBoomboxRinger {
    private final class_1297 entity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxEntityRinger(class_1297 entity, UUID uuid) {
        this.entity = entity;
        this.uuid = uuid;
    }

    @Override
    public class_2561 getRingerName() {
        if (this.entity instanceof class_1542) {
            return new class_2588("imp.ringer.drop", new Object[]{this.getBoombox().method_7954()});
        }
        return new class_2588("imp.ringer.have", new Object[]{this.getBoombox().method_7954(), this.entity.method_5476()});
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218)this.entity.field_6002;
    }

    @Override
    public UUID getRingerUUID() {
        return this.uuid;
    }

    @Override
    public boolean isRingerExist() {
        return BoomboxEntityRinger.canRing(this.entity) && !this.getBoombox().method_7960();
    }

    @Override
    public Pair<class_2960, class_2487> getRingerTracker() {
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            return Pair.of((Object)MusicRingManager.PLAYER_TRACKER, (Object)MusicRingManager.createPlayerTracker(player));
        }
        return Pair.of((Object)MusicRingManager.ENTITY_TRACKER, (Object)MusicRingManager.createEntityTracker(this.entity));
    }

    @Override
    @NotNull
    public class_243 getRingerSpatialPosition() {
        return this.entity.method_19538();
    }

    @NotNull
    private class_1799 getBoombox() {
        class_1542 itemEntity;
        class_1799 item;
        class_1297 li;
        class_1304[] class_1304Array = this.entity;
        if (class_1304Array instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_1304Array;
            class_1304Array = class_1304.values();
            int n = class_1304Array.length;
            for (int i = 0; i < n; ++i) {
                class_1304 value = class_1304Array[i];
                class_1799 item2 = livingEntity.method_6118(value);
                if (!this.uuid.equals(BoomboxItem.getUUID(item2))) continue;
                return item2;
            }
        }
        if ((class_1304Array = this.entity) instanceof class_1657) {
            class_1657 player = (class_1657)class_1304Array;
            li = player.method_31548().method_5438(this.lastInventory);
            if (this.uuid.equals(BoomboxItem.getUUID((class_1799)li))) {
                return li;
            }
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 item3 = player.method_31548().method_5438(i);
                if (!this.uuid.equals(BoomboxItem.getUUID(item3))) continue;
                this.lastInventory = i;
                return item3;
            }
        }
        if (IamMusicPlayer.CONFIG.dropItemRing && (li = this.entity) instanceof class_1542 && this.uuid.equals(BoomboxItem.getUUID(item = (itemEntity = (class_1542)li).method_6983()))) {
            return item;
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    public BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(this.getBoombox());
    }

    public static boolean canRing(class_1297 entity) {
        if (!entity.method_5805()) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !player.method_7325();
        }
        return true;
    }
}

